// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#ifndef __SIGNAL_PICTURE_H__
#define __SIGNAL_PICTURE_H__

#include "BasicPicture.h"
#include "Data.h"
#include "Graph.h"

// ****************************************************************************
/// The picture widget on the screen.
// ****************************************************************************

class SignalPicture : public BasicPicture
{
  // **************************************************************************
  // Public data.
  // **************************************************************************

public:
  enum ValueScaleOption
  {
    MAX_VALUE_4000,
    MAX_VALUE_8000,
    MAX_VALUE_16000,
    AUTOSCALE,
    NUM_VALUE_SCALE_OPTIONS
  };

  // Set this variable for the number of samples (frames) shown in the picture
  int numVisFrames;
  Graph graph;
  ValueScaleOption valueScale;

  // **************************************************************************
  // Public functions.
  // **************************************************************************

public:
  SignalPicture(wxWindow *parent);
  virtual void draw(wxDC &dc);

  // **************************************************************************
  // Private data.
  // **************************************************************************

private:
  wxMenu *contextMenu;
  int menuX, menuY;

  // **************************************************************************
  // Private functions.
  // **************************************************************************

private:
  void OnMouseEvent(wxMouseEvent &event);
  void OnZoomIn(wxCommandEvent &event);
  void OnZoomOut(wxCommandEvent &event);

  void OnMaxValue4000(wxCommandEvent &event);
  void OnMaxValue8000(wxCommandEvent &event);
  void OnMaxValue16000(wxCommandEvent &event);
  void OnAutoscale(wxCommandEvent &event);

  // ****************************************************************************
  // Declare the event table right at the end
  // ****************************************************************************

  DECLARE_EVENT_TABLE()
};

#endif

// ****************************************************************************
